package gui;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import java.awt.event.MouseListener;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import service.*;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;

import gui.jtransitionsystem.*;
import javax.swing.JButton;
import java.util.*;

import javax.swing.JOptionPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

/**
 * @author Serafino & Andrea
 *
 */ 

 
public class ServicePanel extends JPanel{
	
	static final long serialVersionUID = 1L;
	//private JLabel titolo = null;
	private JScrollPane listScroller = null;
	private JTable serviceList = null;
	//private JLabel serviceLabel = null;  
	private JButton serviceButton = null;
	private JPanel buttonPanel = null;
	private JPanel availableServicePanel=null;
	private JPanel targetServicePanel=null;
	//private JLabel titolo1;
	private JScrollPane listScroller1;
	private JTable targetList;
	private JPanel buttonPanel1;
	private JButton targetButton;
	private TableMenu popup;
	
	private JButton removeAvailableService;
	
	public JTable getTargetList(){
		return targetList;
	}
	
	public JTable getServiceList(){
		return serviceList;
	}
	public ServicePanel()
	{
		super();
		initialize();
	}
	
	void initialize()
	{
		popup = new TableMenu();
		availableServicePanel=new JPanel();
		availableServicePanel.setLayout(new BorderLayout());
		/**
		 * adding title to the panel
		 */
		/*
		titolo = new JLabel();
		titolo.setText("Available Services");
		titolo.setHorizontalAlignment(SwingConstants.CENTER);
		availableServicePanel.add(titolo, BorderLayout.NORTH);
		*/
		/**
		 * adding the list to the JScrollerPane
		 */
		listScroller = new JScrollPane(getAvailableServiceList());
		availableServicePanel.add(listScroller, BorderLayout.CENTER);
		/**
		 * adding the button panel
		 */
		buttonPanel = new JPanel();
		buttonPanel.add(getActionButton());
		buttonPanel.add(getRemoveAvailableServiceButton());
		
		availableServicePanel.add(buttonPanel, BorderLayout.SOUTH);
		availableServicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE, 1), "Services Panel", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Arial", Font.BOLD, 14), Color.orange));
		
		targetServicePanel=new JPanel();
		targetServicePanel.setLayout(new BorderLayout());
		//titolo1 = new JLabel();
		//titolo1.setText("Target Service");
		//titolo1.setHorizontalAlignment(SwingConstants.CENTER);
		//targetServicePanel.add(titolo1, BorderLayout.NORTH);
		targetServicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), "Target Service", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Arial", Font.BOLD, 14), Color.BLUE));
		
		listScroller1 = new JScrollPane(getTargetServiceList());
		targetServicePanel.add(listScroller1,BorderLayout.CENTER);

		buttonPanel1 = new JPanel();
		buttonPanel1.add(getActionButton1());
		

		targetServicePanel.add(buttonPanel1, BorderLayout.SOUTH);

		
		JSplitPane splitPane=new JSplitPane(JSplitPane.VERTICAL_SPLIT,availableServicePanel,targetServicePanel);
		splitPane.setDividerLocation((int)Toolkit.getDefaultToolkit().getScreenSize().height/4);

		setLayout(new BorderLayout());
		this.add(splitPane,BorderLayout.CENTER);
	}

	public JButton getActionButton()
	{
		if(serviceButton == null)
		{
			serviceButton = new JButton();
			serviceButton.setText("Show Available Service");
			serviceButton.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					
					showAvailableService();
				}
			}
			);
			serviceButton.setEnabled(false);
		}
		return serviceButton;
	}

	public JButton getActionButton1()
	{
		if(targetButton == null)
		{
			targetButton = new JButton();
			targetButton.setText("Show Target Service");
			targetButton.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					
					showTargetService();
				}
			}
			);
			targetButton.setEnabled(false);
		}
		return targetButton;
	}
	public JButton 	getRemoveAvailableServiceButton()
	{
		if(removeAvailableService == null)
		{
			removeAvailableService = new JButton();
			removeAvailableService.setText("Remove selected service");
			removeAvailableService.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					int index = serviceList.getSelectedRow();
					if(index == -1){
						JOptionPane.showMessageDialog(MainFrame.getInstance(), "No available service selected.", "Error", JOptionPane.ERROR_MESSAGE);
					}
					else
					{
							GenericLoader.getPathAvailableService().removeElementAt(index);
							GenericLoader.getAvailableServices().removeElementAt(index);
							DefaultTableModel tableModel=(DefaultTableModel)serviceList.getModel();
							tableModel.removeRow(index);
					}

				}
			}
			);
			removeAvailableService.setEnabled(false);
		}
		return removeAvailableService;
	}	
	

	
	public JTable getAvailableServiceList()
	{
		if(serviceList == null)
		{
			serviceList=new JTable();
			TableModel tableModel = 
				new DefaultTableModel(
						new String[][]{{}},
						new String[] { "TS name", "State","Filename"});
			serviceList.setModel(tableModel);
			serviceList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
			serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
			serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
			serviceList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			serviceList.setColumnSelectionAllowed(false);
			serviceList.setRowSelectionAllowed(true);
			
			
			serviceList.addMouseMotionListener(
					new MouseMotionListener(){
						 public void mouseMoved(MouseEvent e)
					        {
					            JTable aTable =  (JTable)e.getSource();
					            int itsRow = aTable.rowAtPoint(e.getPoint());
					            if(itsRow>=0 && itsRow<GenericLoader.getPathAvailableService().size())
					            	aTable.setToolTipText(GenericLoader.getPathAvailableService().elementAt(itsRow)); 	
					        }

						@Override
						public void mouseDragged(MouseEvent e) {
							
						}	
					}
			);
			serviceList.addMouseListener(new MouseListener()
			{
				public void mousePressed(MouseEvent e)
				{
					if (e.isPopupTrigger()) {
						JTable service = (JTable)e.getSource();
						int row = service.rowAtPoint(e.getPoint());
						System.out.println(row);
						if(row>=0 && row<GenericLoader.getPathAvailableService().size())
						{
							popup.setSelected(row);
							popup.setUsingTarget(false);
							popup.show(e.getComponent(), e.getX(), e.getY());
						}
			        }

				}

				@Override
				public void mouseClicked(MouseEvent e) 
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseEntered(MouseEvent e) 
				{
					//TODO Auto-generated method stub
				}

				@Override
				public void mouseExited(MouseEvent e) 
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseReleased(MouseEvent e) {
					if (e.isPopupTrigger()) {JTable service = (JTable)e.getSource();
					int row = service.rowAtPoint(e.getPoint());
					if(row>=0 && row<GenericLoader.getPathAvailableService().size())
					{
						popup.setSelected(row);
						popup.setUsingTarget(false);
						popup.show(e.getComponent(), e.getX(), e.getY());
					}
				}
			}});
			showAvailableService();
		
		}
		return serviceList;
		
		
	}
	public JTable getTargetServiceList()
	{
		if(targetList == null)
		{
			targetList=new JTable();
			TableModel tableModel = 
				new DefaultTableModel(
						new String[][]{{}},
						new String[] { "TS name", "State","Filename"});
			targetList.setModel(tableModel);
			targetList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			targetList.getColumnModel().getColumn(0).setPreferredWidth(150);
			targetList.getColumnModel().getColumn(1).setPreferredWidth(150);
			targetList.getColumnModel().getColumn(2).setPreferredWidth(150);
			targetList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			targetList.setColumnSelectionAllowed(false);
			targetList.setRowSelectionAllowed(true);
			targetList.setCellSelectionEnabled(false);
			targetList.setDragEnabled(false);
			
			targetList.addMouseMotionListener(
					new MouseMotionListener(){
						 public void mouseMoved(MouseEvent e)
					        {
					            JTable aTable =  (JTable)e.getSource();
					            int itsRow = aTable.rowAtPoint(e.getPoint());
					            if(itsRow>=0)
					            	aTable.setToolTipText(GenericLoader.getPathTarget()); 	
					        }

						@Override
						public void mouseDragged(MouseEvent e) {
							
						}	
					}
			);
			

			targetList.addMouseListener(new MouseListener()
			{
				public void mousePressed(MouseEvent e)
				{
					if (e.isPopupTrigger()) {
						popup.setUsingTarget(true);
			            popup.show(e.getComponent(),
			                       e.getX(), e.getY());
			        }

				}

				@Override
				public void mouseClicked(MouseEvent e) 
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseEntered(MouseEvent e) 
				{
					//TODO Auto-generated method stub
				}

				@Override
				public void mouseExited(MouseEvent e) 
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseReleased(MouseEvent e) {
					if (e.isPopupTrigger()) {
						popup.setUsingTarget(true);
			            popup.show(e.getComponent(),
			                       e.getX(), e.getY());
			        }

					
				}
			});
		
		}
		return targetList;
		
		
	}
	public void showAvailableService()
	{
		int index = serviceList.getSelectedRow();
		if(index == -1) return;
		else
		{
			Vector<TransitionSystem<SimpleState, SimpleTransition>> availableServices = GenericLoader.getAvailableServices();
			if(availableServices == null )
			{
				JOptionPane.showMessageDialog(null, "No service available. Load available services please.", "Error", JOptionPane.ERROR_MESSAGE);
			}
			
			else
			{
				TransitionSystem<SimpleState, SimpleTransition> availableService = GenericLoader.getAvailableServices().get(index);
				if(availableService.getAllStates().size() >= 20)
				{
					if(JOptionPane.showConfirmDialog(null, "The selected available service has size " + availableService.getAllStates().size()+ " nodes\n"+availableService.getAllActions().size()+" edges\nVisualization could be very slow.\nAre you sure you want to show it anyway?", "Warning", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.YES_OPTION)
					{
						JTransitionSystemSimple javailableService = new JTransitionSystemSimple(availableService);
						GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
						
						graphPanel.printGraph(javailableService.getVisualizationViewer());
						graphPanel.setGraphName(GenericLoader.getAvailableServicesNames().get(index));
						
					}
				}
				else
				{
					JTransitionSystemSimple javailableService = new JTransitionSystemSimple(availableService);
					GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
					
					graphPanel.printGraph(javailableService.getVisualizationViewer());
					graphPanel.setGraphName(GenericLoader.getAvailableServicesNames().get(index));
					
				}
			}
		}
	}
	
	public void showTargetService()
	{
			TransitionSystem<SimpleState, SimpleTransition> targetService = GenericLoader.getTargetService();
			if(targetService == null )
			{
				JOptionPane.showMessageDialog(null, "No target available. Load a target service please.", "Error", JOptionPane.ERROR_MESSAGE);
			}
			
			else
			{
				if(targetService.getAllStates().size() >= 20)
				{
					if(JOptionPane.showConfirmDialog(null, "The selected target service has size " + targetService.getAllStates().size()+ " nodes\n"+targetService.getAllActions().size()+" edges\nVisualization could be very slow.\nAre you sure you want to show it anyway?", "Warning", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.YES_OPTION)
					{
						JTransitionSystemSimple javailableService = new JTransitionSystemSimple(targetService);
						GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
						
						graphPanel.printGraph(javailableService.getVisualizationViewer());
						graphPanel.setGraphName(GenericLoader.getTargetServiceName());
						
					}
				}
				else
				{
					JTransitionSystemSimple javailableService = new JTransitionSystemSimple(targetService);
					GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
					
					graphPanel.printGraph(javailableService.getVisualizationViewer());
					graphPanel.setGraphName(GenericLoader.getTargetServiceName());
					
				}
			}
	}
	
}
